//
//  PMEmailSupportDetailController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/19.
//

import UIKit

class PMEmailSupportDetailController: BaseViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        setuup()
    }
    
    var data:FAQDataModel?

    private func setuup() -> Void {
        scroll.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview().inset(marginLR)
            make.top.equalTo(titleView.snp.bottom).offset(20)
        }
        tl.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.width.equalToSuperview()
        }
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        tl.text = data?.problem ?? ""
        let attribued = addattribed()
        self.view.layoutIfNeeded()
        let bound = attribued.boundingRect(with: CGSizeMake(view.width - marginLR * 2 - 16 * 2, .infinity), options: .usesLineFragmentOrigin, context: nil)
        textView.attributedText = attribued
        textView.snp.makeConstraints { make in
            make.left.right.equalTo(tl)
            make.top.equalTo(tl.snp.bottom).offset(10)
            make.height.equalTo(bound.height+(marginLR * 2 + 16 * 2 + 10))
        }
        DispatchQueue.main.async {
            self.scroll.contentSize = CGSizeMake(0, CGRectGetMaxY(self.textView.frame))
        }
    }
    
    private lazy var tl: UILabel = {
        let l = UILabel()
        l.font = UIFont.systemFont(ofSize: 14, weight: .bold)
        l.textColor = UIColor.colorWithHex(hexStr: "#333333")
        l.numberOfLines = 0
        scroll.addSubview(l)
        return l
    }()
    
    private lazy var textView: UITextView = {
        let tv = UITextView()
        tv.isUserInteractionEnabled = false
        tv.Radius = 12
        tv.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
        tv.textContainerInset = UIEdgeInsets(top: 16, left: 16, bottom: 16, right: 16)
        scroll.addSubview(tv)
        return tv
    }()
    
    private lazy var scroll: UIScrollView = {
        let s = UIScrollView()
        s.showsVerticalScrollIndicator = false
        s.contentInsetAdjustmentBehavior = .never
        view.addSubview(s)
        return s
    }()
    
    private func addattribed() -> NSMutableAttributedString {
        let mutableText = NSMutableAttributedString(string: data?.answer ?? "")
        let param = NSMutableParagraphStyle()
        param.lineSpacing = 5
        mutableText.addAttributes([NSAttributedString.Key.font : UIFont.systemFont(ofSize: 14, weight: .regular),.paragraphStyle:param], range: NSRange(location: 0, length: mutableText.length))
        let rangs = data?.bold ?? []
        let famat = NSSet(array: rangs)
        for text in famat {
            if let rang = mutableText.string.range(of: text as! String) {
                let startIndex = rang.lowerBound
                let endIndex = rang.upperBound
                let start = mutableText.string.distance(from: mutableText.string.startIndex, to: startIndex)
                let end = mutableText.string.distance(from: mutableText.string.startIndex, to: endIndex)
                if end < (data?.answer.count ?? 0) {
                    
                    mutableText.addAttributes([NSAttributedString.Key.font : UIFont.systemFont(ofSize: 14, weight: .bold)], range: NSRange(location: start, length: end - start))
                }
            }
        }
        return mutableText
    }
}
